/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.resolver.FileSystemResolver;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;

public class CacheResolver
extends FileSystemResolver {
    private File _configured = null;

    public CacheResolver() {
    }

    public CacheResolver(Ivy ivy) {
        this.setIvy(ivy);
        this.setName("cache");
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        this.clearIvyAttempts();
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (mrid.isExactRevision()) {
            ResolvedModuleRevision rmr = data.getIvy().findModuleInCache(mrid, data.getCache(), this.doValidate(data));
            if (rmr != null) {
                Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                return rmr;
            }
            Message.verbose("\t" + this.getName() + ": no ivy file in cache found for " + mrid);
            return null;
        }
        this.ensureConfigured(data.getIvy(), data.getCache());
        ResolvedResource ivyRef = this.findIvyFileRef(dd, data);
        if (ivyRef != null) {
            Message.verbose("\t" + this.getName() + ": found ivy file in cache for " + mrid);
            Message.verbose("\t\t=> " + ivyRef);
            ModuleRevisionId resolvedMrid = new ModuleRevisionId(mrid.getModuleId(), ivyRef.getRevision());
            IvyNode node = data.getNode(resolvedMrid);
            if (node != null && node.getModuleRevision() != null) {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + resolvedMrid);
                return this.searchedRmr(node.getModuleRevision());
            }
            ResolvedModuleRevision rmr = data.getIvy().findModuleInCache(resolvedMrid, data.getCache(), this.doValidate(data));
            if (rmr != null) {
                Message.verbose("\t" + this.getName() + ": revision in cache: " + resolvedMrid);
                return this.searchedRmr(rmr);
            }
            Message.error("\t" + this.getName() + ": inconsistent cache: clean it and resolve again");
            return null;
        }
        Message.verbose("\t" + this.getName() + ": no ivy file in cache found for " + mrid);
        return null;
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        this.clearArtifactAttempts();
        DownloadReport dr = new DownloadReport();
        for (int i = 0; i < artifacts.length; ++i) {
            ArtifactDownloadReport adr = new ArtifactDownloadReport(artifacts[i]);
            dr.addArtifactReport(adr);
            File archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i]);
            if (archiveFile.exists()) {
                Message.verbose("\t[NOT REQUIRED] " + artifacts[i]);
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(archiveFile.length());
                continue;
            }
            this.logArtifactNotFound(artifacts[i]);
            adr.setDownloadStatus(DownloadStatus.FAILED);
        }
        return dr;
    }

    public boolean exists(Artifact artifact) {
        this.ensureConfigured();
        return super.exists(artifact);
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        this.ensureConfigured();
        super.publish(artifact, src, overwrite);
    }

    public OrganisationEntry[] listOrganisations() {
        this.ensureConfigured();
        return super.listOrganisations();
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        this.ensureConfigured();
        return super.listModules(org);
    }

    public RevisionEntry[] listRevisions(ModuleEntry module) {
        this.ensureConfigured();
        return super.listRevisions(module);
    }

    public void dumpConfig() {
        Message.verbose("\t" + this.getName() + " [cache]");
    }

    private void ensureConfigured() {
        if (this.getIvy() != null) {
            this.ensureConfigured(this.getIvy(), this.getIvy().getDefaultCache());
        }
    }

    private void ensureConfigured(Ivy ivy, File cache) {
        if (ivy == null || cache == null || this._configured != null && this._configured.equals(cache)) {
            return;
        }
        this.setIvyPatterns(Collections.singletonList(cache.getAbsolutePath() + "/" + ivy.getCacheIvyPattern()));
        this.setArtifactPatterns(Collections.singletonList(cache.getAbsolutePath() + "/" + ivy.getCacheArtifactPattern()));
    }

    public String getTypeName() {
        return "cache";
    }
}

