<?php
require 'config.php';
require 'auth.php';

$perPage = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $perPage;

$msg = $_GET['msg'] ?? '';
$error = '';

// إضافة بيانات جديدة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add'])) {
    $mobile = trim($_POST['mobile']);
    $name = trim($_POST['name']);
    $address = trim($_POST['address']);

    if ($mobile && $name && $address) {
        // السماح بتكرار الرقم بدون تحقق
        $stmt = $pdo->prepare("INSERT INTO users (mobile, name, address) VALUES (?, ?, ?)");
        $stmt->execute([$mobile, $name, $address]);
        $msg = "✅ تم إضافة البيانات بنجاح";
    } else {
        $error = "❌ يرجى ملء كل الحقول";
    }
}

// حذف سجل واحد باستخدام id
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: index.php?page=$page");
    exit;
}

// حذف الكل
if (isset($_GET['delete_all']) && $_GET['delete_all'] == '1') {
    $pdo->exec("DELETE FROM users");
    header("Location: index.php?msg=" . urlencode("✅ تم حذف جميع البيانات"));
    exit;
}

// إجمالي السجلات
$totalCount = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$totalPages = ceil($totalCount / $perPage);

// جلب البيانات للصفحة الحالية
$stmt = $pdo->prepare("SELECT * FROM users ORDER BY id ASC LIMIT $perPage OFFSET $offset");
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8" />
    <title>لوحة التحكم - إدارة البيانات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet" />
</head>
<body class="bg-light">
<div class="container mt-4">
    <div class="d-flex justify-content-between mb-3">
        <h3>📋 إدارة البيانات</h3>
        <div>
            <a href="?delete_all=1" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف جميع البيانات؟')">🗑️ حذف الكل</a>
            <a href="logout.php" class="btn btn-outline-dark">🚪 تسجيل الخروج</a>
        </div>
    </div>

    <?php if (!empty($msg)): ?>
        <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>
    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <!-- إضافة بيانات يدوياً -->
    <div class="card mb-4">
        <div class="card-header">➕ إضافة بيانات جديدة</div>
        <div class="card-body">
            <form method="post" class="row g-3">
                <input type="hidden" name="add" value="1" />
                <div class="col-md-4">
                    <label>رقم الموبايل</label>
                    <input type="text" name="mobile" class="form-control" required pattern="\d+" />
                </div>
                <div class="col-md-4">
                    <label>الاسم</label>
                    <input type="text" name="name" class="form-control" required />
                </div>
                <div class="col-md-4">
                    <label>العنوان</label>
                    <input type="text" name="address" class="form-control" required />
                </div>
                <div class="col-12">
                    <button class="btn btn-primary">حفظ البيانات</button>
                </div>
            </form>
        </div>
    </div>

    <!-- رفع CSV -->
    <div class="card mb-4">
        <div class="card-header">⬆️ رفع ملف CSV</div>
        <div class="card-body">
            <form method="post" action="upload_excel.php" enctype="multipart/form-data">
                <div class="mb-3">
                    <label>اختر ملف CSV (رقم الموبايل، الاسم، العنوان)</label>
                    <input type="file" name="csvFile" accept=".csv" class="form-control" required />
                </div>
                <button type="submit" class="btn btn-success">رفع واستيراد</button>
            </form>
        </div>
    </div>

    <!-- جدول البيانات -->
    <table class="table table-bordered bg-white shadow-sm">
        <thead class="table-dark">
            <tr>
                <th>رقم الموبايل</th>
                <th>الاسم</th>
                <th>العنوان</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $u): ?>
            <tr>
                <td><?= htmlspecialchars($u['mobile']) ?></td>
                <td><?= htmlspecialchars($u['name']) ?></td>
                <td><?= htmlspecialchars($u['address']) ?></td>
                <td>
                    <a href="?delete=<?= $u['id'] ?>&page=<?= $page ?>" class="btn btn-sm btn-danger" onclick="return confirm('هل تريد الحذف؟')">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- شريط التنقل بين الصفحات -->
    <?php if ($totalPages > 1): ?>
    <nav>
        <ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($i == $page ? 'active' : '') ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>
</body>
</html>
