<?php
require 'config.php';
require 'auth.php';

$file = $_GET['file'] ?? '';
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$limit = 10000;

if (!$file || !file_exists($file)) die("❌ الملف غير موجود.");

$handle = fopen($file, "r");
if (!$handle) die("❌ فشل في فتح الملف.");

// تخطي أول سطر (رأس الجدول)
if ($offset === 0) fgetcsv($handle, 0, ";");

// تخطي للصفوف السابقة
for ($i = 0; $i < $offset; $i++) fgetcsv($handle, 0, ";");

$count = 0;
while ($count < $limit && ($data = fgetcsv($handle, 0, ";")) !== false) {
    $mobile = trim($data[0] ?? '');
    $name = trim($data[1] ?? '');
    $address = trim($data[2] ?? '');

    if ($mobile && $name && $address) {
        $stmt = $pdo->prepare("INSERT INTO users (mobile, name, address) VALUES (?, ?, ?)");
        $stmt->execute([$mobile, $name, $address]);
    }

    $count++;
}
fclose($handle);

// هل في المزيد؟
if ($count === $limit) {
    echo "<meta http-equiv='refresh' content='1;url=process_csv.php?file=" . urlencode($file) . "&offset=" . ($offset + $limit) . "' />";
    echo "<p>✅ جاري المعالجة... تم إدخال " . ($offset + $count) . " سجل حتى الآن.</p>";
} else {
    echo "<p>🎉 تم الانتهاء من الاستيراد بالكامل.</p>";
    // يمكنك حذف الملف بعد الاستيراد
    // unlink($file);
}
