<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'config.php';
require 'auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csvFile'])) {
    $fileTmpPath = $_FILES['csvFile']['tmp_name'];
    $fileName = $_FILES['csvFile']['name'];
    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($fileExtension !== 'csv') {
        die("⚠️ الملف المرفوع ليس بصيغة CSV.");
    }

    // اسم فريد للملف لتجنب التعارض
    $uniqueName = 'uploads/' . time() . '_' . basename($fileName);

    if (!is_dir('uploads')) {
        mkdir('uploads', 0755, true);
    }

    if (move_uploaded_file($fileTmpPath, $uniqueName)) {
        // بعد الرفع، نحيله إلى معالج الدُفعات
        header("Location: process_csv.php?file=" . urlencode($uniqueName));
        exit;
    } else {
        die("❌ فشل في حفظ الملف على السيرفر.");
    }
} else {
    die("❌ لم يتم رفع ملف CSV.");
}
