<?php
require 'auth.php';

/* حذف كل السجلات */
if (isset($_GET['delete_all']) && $_GET['delete_all'] == '1') {
    $pdo->exec("DELETE FROM users");
    header("Location: index.php");
    exit;
}

/* إضافة سجل */
if (isset($_POST['add'])) {
    $name        = $_POST['name']        ?? null;
    $birth_date  = !empty($_POST['birth_date']) ? $_POST['birth_date'] : null;
    $address     = $_POST['address']     ?? null;
    $job         = $_POST['job']         ?? null;
    $national_id = $_POST['national_id'] ?? null;

    $stmt = $pdo->prepare("INSERT INTO users (name, birth_date, address, job, national_id) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$name, $birth_date, $address, $job, $national_id]);
    header("Location: index.php");
    exit;
}

/* حذف سجل واحد */
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $pdo->prepare("DELETE FROM users WHERE id = ?")->execute([$id]);
    header("Location: index.php");
    exit;
}

/* بحث + صفحات */
$perPage   = 10;
$page      = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset    = ($page - 1) * $perPage;

$search    = isset($_POST['q']) ? trim($_POST['q']) : '';
$hasSearch = ($search !== '');

if ($hasSearch) {
    $q = "%" . $search . "%";
    $sql = "SELECT * FROM users
            WHERE name        LIKE ?
               OR national_id LIKE ?
               OR address     LIKE ?
               OR job         LIKE ?
               OR birth_date  LIKE ?
            ORDER BY id DESC
            LIMIT 10";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$q, $q, $q, $q, $q]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $countStmt = $pdo->prepare("SELECT COUNT(*) FROM users
                                WHERE name        LIKE ?
                                   OR national_id LIKE ?
                                   OR address     LIKE ?
                                   OR job         LIKE ?
                                   OR birth_date  LIKE ?");
    $countStmt->execute([$q, $q, $q, $q, $q]);
    $searchTotal = (int)$countStmt->fetchColumn();

    $total      = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $totalPages = (int)ceil(max(1, $total) / $perPage);
} else {
    $total      = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $totalPages = (int)ceil(max(1, $total) / $perPage);

    $sql = "SELECT * FROM users ORDER BY id DESC LIMIT $perPage OFFSET $offset";
    $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    $searchTotal = 0;
}

$shownCount = count($rows);
$target     = ($hasSearch && !empty($rows)) ? $rows[0] : ( (!empty($rows)) ? $rows[0] : null );
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>X VECTOR</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --bg:#020617;--cyan:#22d3ee;--purple:#a855f7;--green:#22c55e;
  --text:#e5e7eb;--row:#02091a;
}
*{box-sizing:border-box;margin:0;padding:0}
body{
  background:var(--bg);
  color:var(--text);
  font-family:"Segoe UI",system-ui,sans-serif;
  overflow-x:hidden;
}

/* SPLASH */
#splash{
  position:fixed;inset:0;background:#020617;
  display:flex;flex-direction:column;align-items:center;justify-content:center;
  z-index:10000;
  animation:splashHide 2.5s ease-out forwards;
  animation-delay:0.8s;
}
@keyframes splashHide{
  0%{opacity:1;visibility:visible}
  100%{opacity:0;visibility:hidden;pointer-events:none}
}
.splash-title{
  font-size:2.1rem;letter-spacing:.22em;text-transform:uppercase;
  color:var(--cyan);text-shadow:0 0 20px var(--cyan);
}
.splash-sub{
  font-size:.8rem;color:#9ca3af;letter-spacing:.15em;margin-top:.3rem;
}
.splash-bar{
  width:170px;height:3px;border-radius:999px;overflow:hidden;margin-top:1.2rem;
  background:rgba(15,23,42,.9);
}
.splash-bar-inner{
  width:40%;height:100%;
  background:linear-gradient(90deg,#0ea5e9,#22c55e);
  animation:splashMove 1.4s linear infinite;
}
@keyframes splashMove{
  0%{transform:translateX(-100%)}100%{transform:translateX(250%)}
}

/* BACKGROUND GRID + NETWORK */
.bg-grid{
  position:fixed;inset:0;
  background-image:linear-gradient(rgba(31,41,55,.7) 1px,transparent 1px),
                   linear-gradient(90deg,rgba(31,41,55,.7) 1px,transparent 1px);
  background-size:80px 80px;opacity:.20;
  animation:bgMove 25s linear infinite;
  pointer-events:none;
}
@keyframes bgMove{
  0%{background-position:0 0}100%{background-position:80px 80px}
}
.bg-network-lines{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 30%,rgba(34,211,238,.40),transparent 55%),
    radial-gradient(circle at 70% 20%,rgba(56,189,248,.37),transparent 55%),
    radial-gradient(circle at 30% 80%,rgba(16,185,129,.38),transparent 55%),
    radial-gradient(circle at 82% 75%,rgba(129,140,248,.38),transparent 55%),
    repeating-linear-gradient(120deg,rgba(34,211,238,.25) 0,rgba(34,211,238,.25) 2px,transparent 2px,transparent 6px);
  mix-blend-mode:screen;
  opacity:.23;
  animation:linesMove 18s linear infinite;
  pointer-events:none;
}
@keyframes linesMove{
  0%{background-position:0 0}
  100%{background-position:100px 90px}
}
.scan-lines{
  position:fixed;inset:0;
  background-image:linear-gradient(rgba(15,23,42,.92) 1px,transparent 1px);
  background-size:100% 2px;opacity:.35;pointer-events:none;
}
.scan-bar{
  position:fixed;left:0;right:0;height:160px;
  background:linear-gradient(to bottom,rgba(34,211,238,0)0%,rgba(34,211,238,.18)40%,rgba(34,211,238,0)100%);
  animation:scanDown 7s linear infinite;
  pointer-events:none;opacity:.75;
}
@keyframes scanDown{
  0%{top:-200px}
  100%{top:100%}
}
.network-glow{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 20% 30%,rgba(34,211,238,.25),transparent 55%),
    radial-gradient(circle at 80% 60%,rgba(168,85,247,.22),transparent 55%),
    radial-gradient(circle at 40% 90%,rgba(34,197,94,.27),transparent 55%);
  mix-blend-mode:screen;pointer-events:none;
}

/* NAVBAR */
.navbar{
  background:rgba(15,23,42,.96);
  border-bottom:1px solid rgba(148,163,184,.6);
  backdrop-filter:blur(15px);
}
.badge-online{
  width:8px;height:8px;border-radius:50%;
  background:var(--green);box-shadow:0 0 10px var(--green);
}
.glitch-nav{
  color:var(--text)!important;font-weight:600;letter-spacing:.16em;
  text-transform:uppercase;font-size:.95rem;
  position:relative;display:inline-block;
}
.glitch-nav span{position:relative;display:inline-block}
.glitch-nav span::before,
.glitch-nav span::after{
  content:attr(data-text);
  position:absolute;left:0;top:0;width:100%;
  overflow:hidden;opacity:.65;
}
.glitch-nav span::before{
  color:#22d3ee;text-shadow:0 0 10px rgba(56,189,248,.9);
  clip-path:inset(0 0 55% 0);animation:navG1 2.4s infinite;
}
.glitch-nav span::after{
  color:#a855f7;text-shadow:0 0 10px rgba(168,85,247,.9);
  clip-path:inset(45% 0 0 0);animation:navG2 2.4s infinite;
}
@keyframes navG1{
  0%,100%{clip-path:inset(0 0 55% 0)}
  35%{clip-path:inset(25% 0 40% 0)}
  60%{clip-path:inset(0 0 80% 0)}
}
@keyframes navG2{
  0%,100%{clip-path:inset(45% 0 0 0)}
  30%{clip-path:inset(60% 0 0 0)}
  65%{clip-path:inset(10% 0 50% 0)}
}
.btn-outline{
  border-radius:999px;border-color:rgba(148,163,184,.7);
  color:var(--text)
}
.btn-outline:hover{background:rgba(15,23,42,.95)}
.brand-badge{
  padding:.2rem .7rem;border-radius:999px;
  border:1px solid rgba(148,163,184,.7);
  font-size:.7rem;color:#9ca3af;
}

/* CARDS */
.card-cyber{
  position:relative;
  border-radius:1.4rem;
  border:1px solid rgba(148,163,184,.65);
  background:rgba(15,23,42,.96);
  backdrop-filter:blur(18px);
  box-shadow:0 0 32px rgba(0,0,0,.9);
  overflow:hidden;
  padding:1.2rem 1.4rem;
}
.card-cyber::before{
  content:"";
  position:absolute;
  inset:-1px;
  border-radius:inherit;
  border:1px solid transparent;
  background:conic-gradient(from 0deg,
    rgba(34,211,238,.70),
    rgba(168,85,247,0),
    rgba(34,197,94,.75),
    rgba(168,85,247,.25),
    rgba(34,211,238,.75)
  );
  mask:linear-gradient(#000 0 0) padding-box,linear-gradient(#000 0 0);
  mask-composite:exclude;
  opacity:.3;
  animation:borderSpin 10s linear infinite;

  /* 🔥 الإصلاح هنا */
  z-index:-1 !important;
  pointer-events:none !important;
}
@keyframes borderSpin{
  0%{transform:rotate(0)}
  100%{transform:rotate(360deg)}
}
.small-muted{font-size:.75rem;color:#9ca3af}
.stat-value{font-size:2rem;font-weight:700}
.chip{
  border-radius:999px;
  border:1px solid rgba(148,163,184,.75);
  padding:.15rem .7rem;font-size:.7rem;
  letter-spacing:.08em;color:#9ca3af;
  text-transform:uppercase;
}

/* GLITCH NUMBER */
.glitch-number{
  position:relative;
  display:inline-block;
  font-weight:700;
  letter-spacing:.08em;
  text-shadow:0 0 18px rgba(34,211,238,.9);
}
.glitch-number::before,
.glitch-number::after{
  content:attr(data-text);
  position:absolute;left:0;top:0;width:100%;overflow:hidden;
}
.glitch-number::before{
  color:#22d3ee;text-shadow:0 0 14px rgba(56,189,248,.9);
  clip-path:inset(0 0 55% 0);animation:glNum1 2.6s infinite;
}
.glitch-number::after{
  color:#a855f7;text-shadow:0 0 14px rgba(168,85,247,.9);
  clip-path:inset(45% 0 0 0);animation:glNum2 2.6s infinite;
}
@keyframes glNum1{
  0%,100%{clip-path:inset(0 0 55% 0);opacity:.85}
  35%{clip-path:inset(15% 0 40% 0);opacity:1}
  60%{clip-path:inset(0 0 80% 0);opacity:.7}
}
@keyframes glNum2{
  0%,100%{clip-path:inset(45% 0 0 0);opacity:.9}
  30%{clip-path:inset(60% 0 0 0);opacity:.7}
  65%{clip-path:inset(10% 0 50% 0);opacity:1}
}

/* GLITCH TITLES للكروت والعناوين */
.glitch-title{
  position:relative;
  display:inline-block;
  font-size:.8rem;
  letter-spacing:.12em;
  text-transform:uppercase;
  color:#e5e7eb;
}
.glitch-title::before,
.glitch-title::after{
  content:attr(data-text);
  position:absolute;left:0;top:0;width:100%;pointer-events:none;
}
.glitch-title::before{
  color:#22d3ee;
  text-shadow:0 0 8px rgba(34,211,238,.9);
  opacity:.75;
  animation:gt1 2.4s infinite;
}
.glitch-title::after{
  color:#a855f7;
  text-shadow:0 0 8px rgba(168,85,247,.9);
  opacity:.75;
  animation:gt2 2.4s infinite;
}
@keyframes gt1{
  0%,100%{clip-path:inset(0 0 0 0);}
  40%{clip-path:inset(0 0 40% 0);}
}
@keyframes gt2{
  0%,100%{clip-path:inset(0 0 0 0);}
  60%{clip-path:inset(60% 0 0 0);}
}

/* PLANET */
.planet-wrap{position:relative;width:110px;height:110px;}
.planet{
  position:absolute;inset:10px;border-radius:50%;
  background:radial-gradient(circle at 30% 20%, #e0f2fe 0%, #38bdf8 32%, #1d4ed8 64%, #020617 100%);
  overflow:hidden;box-shadow:0 0 28px rgba(56,189,248,.95);
}
.planet::before{
  content:"";position:absolute;inset:-15%;
  background:
    radial-gradient(circle at 35% 40%, rgba(15,23,42,0) 0, rgba(15,23,42,.9) 52%, transparent 74%),
    radial-gradient(circle at 60% 45%, rgba(15,23,42,0) 0, rgba(15,23,42,.95) 48%, transparent 70%),
    radial-gradient(circle at 65% 60%, rgba(15,23,42,0) 0, rgba(15,23,42,.9) 34%, transparent 58%),
    repeating-radial-gradient(circle at 50% 50%, rgba(15,23,42,0) 0, rgba(15,23,42,0) 8px, rgba(15,23,42,.8) 9px, rgba(15,23,42,.8) 10px),
    linear-gradient(rgba(15,23,42,.7) 1px, transparent 1px),
    linear-gradient(90deg, rgba(15,23,42,.7) 1px, transparent 1px);
  background-size:140% 140%,140% 140%,120% 120%,180px 180px,14px 14px,14px 14px;
  background-position:10% 20%,60% 40%,70% 70%,center,center,center;
  mix-blend-mode:multiply;opacity:.95;
}
.planet-arc{
  position:absolute;inset:0;border-radius:50%;
  border-top:2px solid rgba(56,189,248,.9);
  border-right:2px solid rgba(56,189,248,.4);
  border-left:2px solid transparent;
  border-bottom:2px solid transparent;
  box-shadow:0 0 20px rgba(56,189,248,.8);
  animation:planetSpin 8s linear infinite;
}
@keyframes planetSpin{
  0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}
}

/* TARGET CARD */
.card-target{
  background:
    radial-gradient(circle at 0 0,rgba(34,211,238,.25),transparent 55%),
    radial-gradient(circle at 100% 100%,rgba(168,85,247,.25),transparent 55%),
    rgba(15,23,42,.96);
  box-shadow:0 0 25px rgba(34,211,238,.35),0 0 45px rgba(15,23,42,1);
  transform-style:preserve-3d;
}
.card-target::after{
  content:"";position:absolute;inset:-40%;
  background:linear-gradient(to bottom,rgba(34,211,238,0)0%,rgba(34,211,238,.16)50%,rgba(34,211,238,0)100%);
  opacity:.6;mix-blend-mode:screen;transform:translateY(-60%);animation:targetScan 7s linear infinite;
}
@keyframes targetScan{0%{transform:translateY(-60%)}100%{transform:translateY(60%)}}
.target-face{
  position:relative;width:96px;height:96px;
  margin:0 auto .75rem auto;
  transform:perspective(600px) rotateY(-10deg) rotateX(7deg);
}
.face-orbit{
  position:absolute;inset:-6px;border-radius:50%;
  border:1px dashed rgba(148,163,184,.7);
  box-shadow:0 0 16px rgba(34,211,238,.4);
  animation:orbitSpin 8s linear infinite;
}
@keyframes orbitSpin{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}
.face-core{
  position:absolute;inset:10px;border-radius:50%;
  background:
    radial-gradient(circle at 50% 30%,rgba(15,23,42,1) 0,rgba(15,23,42,.95) 30%,rgba(15,23,42,.6) 60%,transparent 80%),
    radial-gradient(circle at 50% 80%,rgba(15,23,42,1) 0,transparent 60%);
  overflow:hidden;box-shadow:0 0 22px rgba(34,211,238,.55);
}
.face-grid{
  position:absolute;inset:0;
  background-image:linear-gradient(rgba(148,163,184,.45) 1px,transparent 1px),
                   linear-gradient(90deg,rgba(148,163,184,.45) 1px,transparent 1px);
  background-size:10px 10px;mix-blend-mode:soft-light;
}
.face-incognito{
  position:absolute;inset:18px 18px 14px 18px;color:#f9fafb;
}
.face-incognito .hat{
  position:absolute;top:3px;left:50%;width:40px;height:16px;
  background:#f9fafb;border-radius:3px 3px 2px 2px;
  transform:translateX(-50%);box-shadow:0 0 12px rgba(255,255,255,.9);
}
.face-incognito .hat::before{
  content:"";position:absolute;inset:-8px 6px auto 6px;
  border-bottom:18px solid #f9fafb;
  border-left:10px solid transparent;border-right:10px solid transparent;
}
.face-incognito .brim{
  position:absolute;top:20px;left:50%;width:60px;height:4px;
  background:#f9fafb;border-radius:999px;
  transform:translateX(-50%);box-shadow:0 0 10px rgba(255,255,255,.7);
}
.face-incognito .glasses{
  position:absolute;top:32px;left:50%;width:52px;height:18px;
  transform:translateX(-50%);
}
.face-incognito .circle{
  position:absolute;top:0;width:18px;height:18px;
  border-radius:50%;border:3px solid #f9fafb;
  box-shadow:0 0 10px rgba(255,255,255,.9);
}
.face-incognito .circle.left{left:0;}
.face-incognito .circle.right{right:0;}
.face-incognito .bridge{
  position:absolute;top:7px;left:50%;width:14px;height:4px;
  background:#f9fafb;transform:translateX(-50%);
  box-shadow:0 0 8px rgba(255,255,255,.8);
}
.face-id{
  position:absolute;bottom:-10px;left:50%;transform:translateX(-50%);
  padding:.1rem .5rem;border-radius:999px;
  background:rgba(15,23,42,.95);border:1px solid rgba(148,163,184,.9);
  font-size:.65rem;letter-spacing:.12em;
}

.target-label{font-size:.7rem;text-transform:uppercase;letter-spacing:.12em;color:#9ca3af}
.target-value{font-size:.9rem;font-weight:500}

/* FORMS */
.form-control{
  background:rgba(15,23,42,.95);
  border:1px solid rgba(148,163,184,.7);
  color:#fff;border-radius:999px;
}
.form-control:focus{border-color:var(--cyan);box-shadow:0 0 8px var(--cyan)}
.form-control::placeholder{
  color:#e5e7eb;
  opacity:.8;
}
.btn-cyber{
  border-radius:999px;border:1px solid var(--cyan);
  background:linear-gradient(135deg,#0ea5e9,#22c55e);
  color:#020617;font-weight:600;
  box-shadow:0 0 18px var(--cyan);
}

/* GLITCH HEADERS للجدول */
.glitch-head{
  position:relative;
  display:inline-block;
  font-size:.80rem;
  letter-spacing:.10em;
  text-transform:uppercase;
  color:#e5e7eb;
}
.glitch-head::before,
.glitch-head::after{
  content:attr(data-text);
  position:absolute;
  left:0;top:0;
  width:100%;
  pointer-events:none;
}
.glitch-head::before{
  color:#22d3ee;
  text-shadow:0 0 8px rgba(34,211,238,.9);
  opacity:.8;
  animation:headGlitch1 2.3s infinite;
}
.glitch-head::after{
  color:#a855f7;
  text-shadow:0 0 8px rgba(168,85,247,.9);
  opacity:.8;
  animation:headGlitch2 2.3s infinite;
}
@keyframes headGlitch1{
  0%,100%{clip-path:inset(0 0 0 0);}
  40%   {clip-path:inset(0 0 40% 0);}
}
@keyframes headGlitch2{
  0%,100%{clip-path:inset(0 0 0 0);}
  55%   {clip-path:inset(60% 0 0 0);}
}

/* TABLE */
.table{
  width:100%;
  border-collapse:collapse;
  table-layout:fixed;
  color:#ffffff;
  font-size:.85rem;
  margin-bottom:0;
  direction:rtl;
}
.table thead,
.table thead tr,
.table thead th{
  background-color:var(--row) !important;
}
.table th,
.table td{
  padding:.8rem .6rem;
  text-align:center;
  vertical-align:middle;
  border-right:1px solid rgba(15,23,42,.9);
  white-space:nowrap;
}
.table th:last-child,
.table td:last-child{
  border-right:none;
}

/* ROWS */
.table tbody tr:nth-of-type(odd)>*{background:var(--row);color:#fff;}
.table tbody tr:nth-of-type(even)>*{background:#030b21;color:#fff;}
.table-hover tbody tr:hover>*{background:rgba(8,47,73,.9);color:#fff;}

.row-user{
  position:relative;
  transition:background .18s,transform .15s,box-shadow .15s;
  cursor:pointer;
}
.row-user::before{
  content:none;
  position:absolute;
  inset:0;
  background:
    radial-gradient(circle at 0 0,rgba(34,211,238,.18),transparent 55%),
    radial-gradient(circle at 100% 100%,rgba(168,85,247,.18),transparent 55%);
  opacity:0;
  transition:opacity .15s;
  z-index:-1;
}
ity:0;transition:opacity .15s;z-index:-1;
}
.row-user:hover::before{opacity:1;}
.row-user:hover{box-shadow:0 0 22px rgba(34,211,238,.8);transform:translateY(-1px);}

/* PAGINATION */
.pagination .page-link{
  background:rgba(15,23,42,.95);
  border-color:rgba(148,163,184,.7);
  color:var(--text);
}
.pagination .page-link:hover{background:rgba(30,64,175,.8)}
.pagination .active .page-link{
  background:var(--cyan);
  border-color:var(--cyan);
  color:#020617;
}

/* CURSOR X */
.cursor-dot,.cursor-ring{
  position:fixed;top:0;left:0;transform:translate(-50%,-50%);
  pointer-events:none;z-index:9999;
}
.cursor-dot{
  width:14px;height:14px;
  background:transparent;
  box-shadow:0 0 18px rgba(34,211,238,.95);
}
.cursor-dot::before,
.cursor-dot::after{
  content:"";position:absolute;left:50%;top:50%;
  width:14px;height:2px;background:var(--cyan);
  border-radius:999px;transform-origin:center;
}
.cursor-dot::before{transform:translate(-50%,-50%) rotate(45deg);}
.cursor-dot::after{transform:translate(-50%,-50%) rotate(-45deg);}
.cursor-ring{
  width:36px;height:36px;border-radius:999px;
  border:1px solid var(--cyan);
  box-shadow:0 0 20px var(--purple);
}
.click-ripple{
  position:fixed;width:6px;height:6px;
  border-radius:50%;border:1px solid var(--cyan);
  transform:translate(-50%,-50%);
  animation:ripple .4s ease-out forwards;
  z-index:9998;
}
@keyframes ripple{
  from{transform:translate(-50%,-50%) scale(.7);opacity:1}
  to{transform:translate(-50%,-50%) scale(6);opacity:0}
}
@media(max-width:768px){
  .cursor-dot,.cursor-ring{display:none}
}
</style>
</head>
<body>

<div id="splash">
  <div class="splash-title">X VECTOR</div>
  <div class="splash-sub">NODE CONSOLE · DASHBOARD</div>
  <div class="splash-bar"><div class="splash-bar-inner"></div></div>
</div>

<div class="bg-grid"></div>
<div class="bg-network-lines"></div>
<div class="scan-lines"></div>
<div class="scan-bar"></div>
<div class="network-glow"></div>

<div class="cursor-dot"></div>
<div class="cursor-ring"></div>

<audio id="snd-click"  src="sounds/click.mp3"  preload="auto"></audio>
<audio id="snd-search" src="sounds/search.mp3" preload="auto"></audio>
<audio id="snd-delete" src="sounds/delete.mp3" preload="auto"></audio>

<nav class="navbar navbar-expand-lg px-3 mb-4">
  <div class="container-fluid">
    <div class="d-flex align-items-center gap-2">
      <span class="badge-online"></span>
      <a class="navbar-brand glitch-nav" href="#">
        <span data-text="X VECTOR">X VECTOR</span>
      </a>
      <span class="brand-badge d-none d-md-inline">NODE CONSOLE</span>
    </div>
    <div class="ms-auto">
      <a href="logout.php" class="btn btn-outline-danger btn-sm">خروج</a>
    </div>
  </div>
</nav>

<div class="container mb-5">

  <!-- الكروت -->
  <div class="row g-3 mb-4">
    <div class="col-lg-3 col-md-6">
      <div class="card-cyber h-100">
        <div class="d-flex justify-content-between mb-2">
          <span class="glitch-title" data-text="إجمالي السجلات">إجمالي السجلات</span>
          <span class="chip">DB STATUS</span>
        </div>
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="stat-value mb-1">
              <span class="glitch-number" data-text="<?php echo $total; ?>">
                <?php echo $total; ?>
              </span>
            </div>
            <div class="small-muted">
              المعروض الآن: <?php echo $shownCount; ?><br>
              الصفحة: <?php echo $hasSearch ? 'بحث' : ($page . ' من ' . max(1, $totalPages)); ?>
            </div>
          </div>
          <div class="planet-wrap d-none d-md-block">
            <div class="planet"><div class="planet-arc"></div></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-5 col-md-6">
      <div class="card-cyber h-100">
        <div class="d-flex justify-content-between mb-2">
          <span class="glitch-title" data-text="بحث داخل شبكة X VECTOR">بحث داخل شبكة X VECTOR</span>
          <span class="chip"><?php echo $hasSearch ? 'TRACE ACTIVE' : 'TRACE IDLE'; ?></span>
        </div>
        <form method="post" id="searchForm" class="row g-2">
          <div class="col-sm-9">
            <input type="text" name="q" class="form-control"
                   placeholder="ابحث باسم أو رقم قومي أو عنوان أو مهنة..."
                   value="<?php echo htmlspecialchars($search); ?>">
          </div>
          <div class="col-sm-3">
            <button class="btn-cyber w-100">SCAN</button>
          </div>
        </form>
        <div class="small-muted mt-2">
          <?php if ($hasSearch): ?>
            تم العثور على <?php echo $searchTotal; ?> نتيجة، يتم عرض أول <?php echo $shownCount; ?>:
            <b><?php echo htmlspecialchars($search); ?></b>
          <?php else: ?>
            عرض آخر <?php echo $shownCount; ?> سجل (10 لكل صفحة).
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-lg-4">
      <div class="card-cyber card-target h-100" id="targetCard" style="<?php echo $target ? '' : 'opacity:.4;'; ?>">
        <div class="d-flex justify-content-between mb-2">
          <span class="glitch-title" data-text="TARGET PROFILE">TARGET PROFILE</span>
          <span class="chip"><?php echo $target ? 'LOCKED' : 'IDLE'; ?></span>
        </div>
        <div class="target-face">
          <div class="face-orbit"></div>
          <div class="face-core">
            <div class="face-grid"></div>
            <div class="face-incognito">
              <div class="hat"></div>
              <div class="brim"></div>
              <div class="glasses">
                <div class="circle left"></div>
                <div class="circle right"></div>
                <div class="bridge"></div>
              </div>
            </div>
          </div>
          <div class="face-id" id="t-id">
            <?php echo $target ? htmlspecialchars($target['national_id']) : 'NO-ID'; ?>
          </div>
        </div>
        <div id="targetContent">
          <div class="mb-1">
            <div class="target-label">الاسم</div>
            <div class="target-value" id="t-name"><?php echo $target ? htmlspecialchars($target['name']) : ''; ?></div>
          </div>
          <div class="mb-1">
            <div class="target-label">تاريخ الميلاد</div>
            <div class="target-value" id="t-birth"><?php echo $target ? htmlspecialchars($target['birth_date']) : ''; ?></div>
          </div>
          <div class="mb-1">
            <div class="target-label">العنوان</div>
            <div class="target-value" id="t-address"><?php echo $target ? htmlspecialchars($target['address']) : ''; ?></div>
          </div>
          <div class="mb-1">
            <div class="target-label">المهنة</div>
            <div class="target-value" id="t-job"><?php echo $target ? htmlspecialchars($target['job']) : ''; ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- جدول بيانات المستخدمين -->
  <div class="row g-3 mb-4">
    <div class="col-12">
      <div class="card-cyber position-relative mb-0">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <span class="glitch-title" data-text="بيانات المستخدمين">بيانات المستخدمين</span>
          <a href="index.php?delete_all=1"
             class="btn btn-outline-danger btn-sm btn-delete-all"
             onclick="return confirm('تحذير: سيتم حذف كل السجلات نهائيًا، متأكد؟');">
             حذف كل السجلات
          </a>
        </div>

        <!-- من اليمين للشمال: # | الاسم | تاريخ الميلاد | العنوان | المهنة | الرقم القومي | حذف -->
        <table class="table table-hover text-center align-middle">
          <colgroup>
            <col style="width:7%">   <!-- # -->
            <col style="width:15%">  <!-- الاسم -->
            <col style="width:16%">  <!-- تاريخ الميلاد -->
            <col style="width:22%">  <!-- العنوان -->
            <col style="width:12%">  <!-- المهنة -->
            <col style="width:18%">  <!-- الرقم القومي -->
            <col style="width:10%">  <!-- حذف -->
          </colgroup>
          <thead>
            <tr>
              <th><span class="glitch-head" data-text="#">#</span></th>
              <th><span class="glitch-head" data-text="الاسم">الاسم</span></th>
              <th><span class="glitch-head" data-text="تاريخ الميلاد">تاريخ الميلاد</span></th>
              <th><span class="glitch-head" data-text="العنوان">العنوان</span></th>
              <th><span class="glitch-head" data-text="المهنة">المهنة</span></th>
              <th><span class="glitch-head" data-text="الرقم القومي">الرقم القومي</span></th>
              <th><span class="glitch-head" data-text="حذف">حذف</span></th>
            </tr>
          </thead>
          <tbody>
          <?php $i = 1; if (empty($rows)): ?>
            <tr><td colspan="7" class="py-4 small-muted">لا توجد بيانات مطابقة.</td></tr>
          <?php else: foreach ($rows as $r): ?>
            <tr class="row-user"
                data-name="<?php echo htmlspecialchars($r['name']); ?>"
                data-birth="<?php echo htmlspecialchars($r['birth_date']); ?>"
                data-address="<?php echo htmlspecialchars($r['address']); ?>"
                data-job="<?php echo htmlspecialchars($r['job']); ?>"
                data-nid="<?php echo htmlspecialchars($r['national_id']); ?>">
              <!-- أول خانة رقم تسلسلي -->
              <td><?php echo $i++; ?></td>
              <td><?php echo htmlspecialchars($r['name']); ?></td>
              <td><?php echo htmlspecialchars($r['birth_date']); ?></td>
              <td><?php echo htmlspecialchars($r['address']); ?></td>
              <td><?php echo htmlspecialchars($r['job']); ?></td>
              <td><?php echo htmlspecialchars($r['national_id']); ?></td>
              <td>
                <a href="index.php?delete=<?php echo $r['id']; ?>"
                   class="btn btn-sm btn-outline-danger btn-delete"
                   onclick="return confirm('هل تريد حذف هذا السجل؟');">حذف</a>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>

      <?php if (!$hasSearch && $totalPages > 1): ?>
      <nav aria-label="pageNav" class="mt-3">
        <ul class="pagination justify-content-center mb-0">
          <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
            <a class="page-link" href="index.php?page=<?php echo max(1, $page-1); ?>">السابق</a>
          </li>
          <?php for ($p = 1; $p <= $totalPages; $p++): ?>
            <li class="page-item <?php echo $p == $page ? 'active' : ''; ?>">
              <a class="page-link" href="index.php?page=<?php echo $p; ?>"><?php echo $p; ?></a>
            </li>
          <?php endfor; ?>
          <li class="page-item <?php echo $page >= $totalPages ? 'disabled' : ''; ?>">
            <a class="page-link" href="index.php?page=<?php echo min($totalPages, $page+1); ?>">التالي</a>
          </li>
        </ul>
      </nav>
      <?php endif; ?>
    </div>
  </div>

  <!-- إضافة سجل جديد -->
  <div class="row g-3 mb-4">
    <div class="col-12 col-lg-8 mx-auto">
      <div class="card-cyber mt-0">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <span class="glitch-title" data-text="إضافة سجل جديد">إضافة سجل جديد</span>
          <a href="upload_excel.php" class="btn btn-outline btn-sm">رفع Excel/CSV</a>
        </div>
        <form method="post" class="row g-3" id="addForm">
          <div class="col-md-4"><input name="name" class="form-control" placeholder="الاسم" required></div>
          <div class="col-md-4"><input name="birth_date" type="date" class="form-control"></div>
          <div class="col-md-4"><input name="job" class="form-control" placeholder="المهنة"></div>
          <div class="col-md-6"><input name="address" class="form-control" placeholder="العنوان"></div>
          <div class="col-md-6"><input name="national_id" class="form-control" placeholder="الرقم القومي"></div>
          <div class="col-12 text-end">
            <button name="add" class="btn-cyber px-4">إضافة</button>
          </div>
        </form>
      </div>
    </div>
  </div>

</div>

<script>
const dot=document.querySelector('.cursor-dot');
const ring=document.querySelector('.cursor-ring');
let mx=window.innerWidth/2,my=window.innerHeight/2,rx=mx,ry=my;
document.addEventListener('mousemove',e=>{
  mx=e.clientX;my=e.clientY;
  if(dot) dot.style.transform=`translate(${mx}px,${my}px)`;
});
function animateCursor(){
  rx+=(mx-rx)*0.15;ry+=(my-ry)*0.15;
  if(ring) ring.style.transform=`translate(${rx}px,${ry}px)`;
  requestAnimationFrame(animateCursor);
}
animateCursor();

const sndClick=document.getElementById('snd-click');
const sndSearch=document.getElementById('snd-search');
const sndDelete=document.getElementById('snd-delete');

document.addEventListener('click',e=>{
  if(sndClick){sndClick.currentTime=0;sndClick.play().catch(()=>{});}
  const r=document.createElement('div');
  r.className='click-ripple';
  r.style.left=e.clientX+'px';
  r.style.top =e.clientY+'px';
  document.body.appendChild(r);
  setTimeout(()=>r.remove(),400);
});

const searchForm=document.getElementById('searchForm');
if(searchForm && sndSearch){
  searchForm.addEventListener('submit',()=>{
    sndSearch.currentTime=0;sndSearch.play().catch(()=>{});
  });
}
document.querySelectorAll('.btn-delete').forEach(btn=>{
  btn.addEventListener('click',()=>{
    if(sndDelete){sndDelete.currentTime=0;sndDelete.play().catch(()=>{});}
  });
});

function setTargetFromRow(tr){
  const name=tr.dataset.name||'';
  const birth=tr.dataset.birth||'';
  const address=tr.dataset.address||'';
  const job=tr.dataset.job||'';
  const nid=tr.dataset.nid||'';

  const card=document.getElementById('targetCard');
  const tn=document.getElementById('t-name');
  const tb=document.getElementById('t-birth');
  const ta=document.getElementById('t-address');
  const tj=document.getElementById('t-job');
  const tid=document.getElementById('t-id');

  if(card) card.style.opacity='1';
  if(tn) tn.textContent=name;
  if(tb) tb.textContent=birth;
  if(ta) ta.textContent=address;
  if(tj) tj.textContent=job;
  if(tid) tid.textContent=nid || 'NO-ID';
}
document.querySelectorAll('.row-user').forEach(tr=>{
  tr.addEventListener('click',()=>setTargetFromRow(tr));
});
</script>

</body>
</html>
