<?php
require 'config.php';

if (isset($_POST['username'], $_POST['password'])) {
    $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ?");
    $stmt->execute([$_POST['username']]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($admin) {
        $inputHash = hash('sha256', $_POST['password']);
        if ($inputHash === $admin['password']) {
            $_SESSION['admin_id'] = $admin['id'];
            header("Location: index.php");
            exit;
        }
    }
    $error = "بيانات الدخول غير صحيحة";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>X Vector Access Gate</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --bg-main: #020617;
            --accent-cyan: #22d3ee;
            --accent-purple: #a855f7;
            --accent-green: #22c55e;
            --accent-red: #f97373;
            --text-main: #e5e7eb;
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            background:
                radial-gradient(circle at 10% 0%, rgba(56,189,248,0.18), transparent 55%),
                radial-gradient(circle at 100% 100%, rgba(168,85,247,0.22), transparent 55%),
                #020617;
            color: var(--text-main);
            font-family: system-ui, -apple-system, BlinkMacSystemFont,"Segoe UI",sans-serif;
            overflow-x: hidden;
            cursor: none;
        }

        .bg-grid {
            position: fixed;
            inset: 0;
            background-image:
                linear-gradient(rgba(31,41,55,0.7) 1px, transparent 1px),
                linear-gradient(90deg, rgba(31,41,55,0.7) 1px, transparent 1px);
            background-size: 60px 60px;
            mix-blend-mode: screen;
            opacity: .18;
            pointer-events: none;
            animation: gridMove 25s linear infinite;
        }
        @keyframes gridMove {
            0% { background-position: 0 0, 0 0; }
            100% { background-position: 60px 60px,60px 60px; }
        }

        .scan-lines {
            position: fixed;
            inset: 0;
            pointer-events: none;
            background-image: linear-gradient(rgba(15,23,42,0.9) 1px, transparent 1px);
            background-size: 100% 2px;
            opacity: .35;
            mix-blend-mode: soft-light;
        }

        .scan-bar {
            position: fixed;
            left: 0;
            right: 0;
            height: 160px;
            background: linear-gradient(to bottom,
                        rgba(34,211,238,0) 0%,
                        rgba(34,211,238,0.12) 40%,
                        rgba(34,211,238,0) 100%);
            filter: blur(2px);
            animation: scanDown 6s linear infinite;
            pointer-events: none;
            mix-blend-mode: screen;
            opacity: .7;
        }
        @keyframes scanDown {
            0%   { top:-160px; }
            100% { top:100%; }
        }

        .login-shell {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1.5rem;
            position: relative;
            z-index: 2;
        }

        .terminal-card {
            position: relative;
            max-width: 420px;
            width: 100%;
            background:
                radial-gradient(circle at 0 0, rgba(34,211,238,0.2), transparent 55%),
                radial-gradient(circle at 100% 100%, rgba(168,85,247,0.18), transparent 55%),
                rgba(15,23,42,0.94);
            border-radius: 1.5rem;
            border: 1px solid rgba(148,163,184,0.7);
            box-shadow:
                0 0 30px rgba(15,23,42,1),
                0 0 40px rgba(34,211,238,0.28);
            backdrop-filter: blur(18px);
            padding: 2rem 2.2rem;
            overflow: hidden;
        }

        .terminal-card::before {
            content:"";
            position:absolute;
            inset:-1px;
            border-radius:inherit;
            border:1px solid transparent;
            background:
                conic-gradient(from 0deg,
                    rgba(34,211,238,0.65),
                    rgba(168,85,247,0),
                    rgba(34,197,94,0.75),
                    rgba(168,85,247,0.1),
                    rgba(34,211,238,0.75));
            mask:linear-gradient(#000 0 0) padding-box,linear-gradient(#000 0 0);
            mask-composite: exclude;
            opacity:.45;
            pointer-events:none;
            animation:borderSpin 9s linear infinite;
        }
        @keyframes borderSpin { 0% {transform:rotate(0deg);} 100%{transform:rotate(360deg);} }

        .header-line {
            display:flex;
            align-items:center;
            justify-content:space-between;
            gap:.75rem;
            margin-bottom:1.5rem;
        }

        .glitch-title {
            font-size:1.2rem;
            font-weight:600;
            letter-spacing:.12em;
            text-transform:uppercase;
            position:relative;
        }
        .glitch-title span {
            position:relative;
            display:inline-block;
        }
        .glitch-title span::before,
        .glitch-title span::after {
            content: attr(data-text);
            position:absolute;
            left:0;
            top:0;
            width:100%;
            overflow:hidden;
        }
        .glitch-title span::before {
            left:1px;
            color:#22d3ee;
            text-shadow:0 0 10px rgba(56,189,248,.9);
            clip-path: inset(0 0 60% 0);
            animation:gl1 2.2s infinite;
        }
        .glitch-title span::after {
            left:-1px;
            color:#a855f7;
            text-shadow:0 0 10px rgba(168,85,247,.9);
            clip-path: inset(40% 0 0 0);
            animation:gl2 2.2s infinite;
        }
        @keyframes gl1 {
            0%,100%{clip-path: inset(0 0 60% 0);}
            30%{clip-path: inset(20% 0 40% 0);}
            60%{clip-path: inset(0 0 80% 0);}
        }
        @keyframes gl2 {
            0%,100%{clip-path: inset(40% 0 0 0);}
            30%{clip-path: inset(60% 0 0 0);}
            60%{clip-path: inset(10% 0 50% 0);}
        }

        .status-pill {
            display:flex;
            align-items:center;
            gap:.35rem;
            padding:.2rem .7rem;
            border-radius:999px;
            border:1px solid rgba(148,163,184,0.7);
            font-size:.7rem;
            text-transform:uppercase;
            letter-spacing:.12em;
            color:#9ca3af;
            background:rgba(15,23,42,0.9);
        }
        .status-dot {
            width:8px;
            height:8px;
            border-radius:999px;
            background:var(--accent-green);
            box-shadow:0 0 12px rgba(34,197,94,.9);
            animation:pulse 1.6s infinite alternate;
        }
        @keyframes pulse {
            0% { transform:scale(.85); opacity:.7; }
            100%{ transform:scale(1.15); opacity:1; }
        }

        .small-muted { font-size:.75rem; color:#9ca3af; }

        .form-control {
            background:rgba(15,23,42,0.9);
            border-radius:999px;
            border:1px solid rgba(148,163,184,0.7);
            color:var(--text-main);
        }
        .form-control:focus {
            border-color:var(--accent-cyan);
            box-shadow:0 0 0 1px rgba(56,189,248,.4);
            background:rgba(15,23,42,0.98);
        }

        .btn-cyber {
            border-radius:999px;
            border:1px solid rgba(56,189,248,0.9);
            background:
                radial-gradient(circle at 0 0, rgba(56,189,248,.5), transparent 55%),
                linear-gradient(135deg,#0ea5e9,#22c55e);
            color:#020617;
            font-weight:600;
            width:100%;
            box-shadow:
                0 0 18px rgba(56,189,248,.7),
                0 0 35px rgba(15,23,42,1);
            transition:transform .12s ease, box-shadow .12s ease;
        }
        .btn-cyber:hover {
            transform:translateY(-1px);
            box-shadow:
                0 0 22px rgba(56,189,248,.9),
                0 0 40px rgba(15,23,42,1);
        }

        .alert-cyber {
            border-radius:.9rem;
            border:1px solid rgba(248,113,113,0.7);
            background:rgba(127,29,29,0.45);
            color:#fecaca;
            font-size:.85rem;
        }

        .cursor-dot,
        .cursor-ring {
            position:fixed;
            top:0; left:0;
            pointer-events:none;
            transform:translate(-50%, -50%);
            z-index:9999;
        }
        .cursor-dot {
            width:9px; height:9px;
            border-radius:50%;
            background:var(--accent-cyan);
            box-shadow:0 0 14px rgba(56,189,248,.9);
        }
        .cursor-ring {
            width:38px; height:38px;
            border-radius:999px;
            border:1px solid rgba(56,189,248,.7);
            box-shadow:
                0 0 22px rgba(56,189,248,.5),
                0 0 40px rgba(168,85,247,.3);
            backdrop-filter:blur(4px);
        }

        .click-ripple {
            position:fixed;
            width:6px; height:6px;
            border-radius:999px;
            border:1px solid rgba(56,189,248,.6);
            transform:translate(-50%,-50%);
            pointer-events:none;
            opacity:.9;
            animation:rippleOut .4s ease-out forwards;
            z-index:9998;
        }
        @keyframes rippleOut {
            from { transform:translate(-50%,-50%) scale(.7); opacity:.9; }
            to   { transform:translate(-50%,-50%) scale(5); opacity:0; }
        }

        @media (max-width: 576px) {
            body { cursor:auto; overflow-y:auto; }
            .cursor-dot,.cursor-ring { display:none; }
            .terminal-card { padding:1.5rem; }
        }
    </style>
</head>
<body>

<div class="bg-grid"></div>
<div class="scan-lines"></div>
<div class="scan-bar"></div>

<div class="cursor-dot"></div>
<div class="cursor-ring"></div>

<audio id="snd-click" src="sounds/click.mp3" preload="auto"></audio>
<audio id="snd-error" src="sounds/access_denied.mp3" preload="auto"></audio>

<div class="login-shell">
    <div class="terminal-card">
        <div class="header-line">
            <div class="glitch-title">
                <span data-text="X VECTOR">X VECTOR</span>
            </div>
            <div class="status-pill">
                <div class="status-dot"></div>
                <span>SECURE LINK</span>
            </div>
        </div>

        <p class="small-muted mb-4">
            بوابة الدخول إلى نظام X Vector. أي محاولة دخول غير مصرح بها سيتم تتبعها فورًا.
        </p>

        <?php if (!empty($error)): ?>
            <div class="alert alert-cyber py-2 px-3 mb-3">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>

        <form method="post" autocomplete="off" id="loginForm">
            <div class="mb-3">
                <label class="form-label">اسم المستخدم</label>
                <input type="text" name="username" class="form-control" required autofocus>
            </div>

            <div class="mb-3">
                <label class="form-label">كلمة المرور</label>
                <input type="password" name="password" class="form-control" required>
            </div>

            <button type="submit" class="btn-cyber">
                CONNECT TO X VECTOR CORE
            </button>
        </form>

        <div class="d-flex justify-content-between small-muted mt-3">
            <span>• X VECTOR NODE •</span>
            <span>ENCRYPTION: AES-256</span>
        </div>
    </div>
</div>

<script>
const dot  = document.querySelector('.cursor-dot');
const ring = document.querySelector('.cursor-ring');

let mouseX = window.innerWidth / 2;
let mouseY = window.innerHeight / 2;
let ringX  = mouseX;
let ringY  = mouseY;

document.addEventListener('mousemove', (e) => {
    mouseX = e.clientX;
    mouseY = e.clientY;
    if (dot) dot.style.transform = `translate(${mouseX}px, ${mouseY}px)`;
});

function animateRing() {
    const speed = 0.18;
    ringX += (mouseX - ringX) * speed;
    ringY += (mouseY - ringY) * speed;
    if (ring) ring.style.transform = `translate(${ringX}px, ${ringY}px)`;
    requestAnimationFrame(animateRing);
}
animateRing();

const sndClick = document.getElementById('snd-click');
const sndErr   = document.getElementById('snd-error');

document.addEventListener('click', (e) => {
    if (sndClick) { sndClick.currentTime = 0; sndClick.play().catch(()=>{}); }

    const ripple = document.createElement('div');
    ripple.className = 'click-ripple';
    ripple.style.left = `${e.clientX}px`;
    ripple.style.top  = `${e.clientY}px`;
    document.body.appendChild(ripple);
    setTimeout(() => ripple.remove(), 400);
});

<?php if (!empty($error)): ?>
window.addEventListener('load', () => {
    if (sndErr) sndErr.play().catch(()=>{});
});
<?php endif; ?>
</script>

</body>
</html>
