<?php
require 'auth.php';

// رسائل
$msg  = "";
$err  = "";

// لازم ييجي من صفحة الرفع ومعاه ملف
if (!isset($_POST['upload']) || !isset($_FILES['file'])) {
    header("Location: upload_excel.php");
    exit;
}

if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    $err = "خطأ في رفع الملف";
} else {
    $tmpName  = $_FILES['file']['tmp_name'];
    $origName = $_FILES['file']['name'];
    $ext      = strtolower(pathinfo($origName, PATHINFO_EXTENSION));

    // حجم الدفعة (10,000 صف)
    $batchSize     = 10000;
    $currentBatch  = 0;
    $count         = 0;

    try {
        // تجهيز جملة الإدخال
        $stmt = $pdo->prepare("
            INSERT INTO users (name, birth_date, address, job, national_id)
            VALUES (?, ?, ?, ?, ?)
        ");

        // ========== معالجة CSV ==========
        if ($ext === 'csv') {

            if (($handle = fopen($tmpName, "r")) === false) {
                throw new Exception("تعذر فتح ملف CSV");
            }

            // نكشف الفاصل من أول سطر (لو فيه ; نستخدمه، غير كده نخليها ,)
            $firstLine = fgets($handle);
            if ($firstLine === false) {
                throw new Exception("ملف CSV فارغ.");
            }
            $delimiter = (strpos($firstLine, ';') !== false) ? ';' : ',';

            // رجوع للمؤشر لبداية الملف
            rewind($handle);

            // قراءة الهيدر وتجاهله (أول صف)
            $header = fgetcsv($handle, 0, $delimiter);
            // متوقع: name;birth_date;address;job;national_id

            // بدء Transaction
            $pdo->beginTransaction();

            while (($data = fgetcsv($handle, 0, $delimiter)) !== false) {

                // تجاهل السطور الفارغة
                if (count($data) === 1 && trim($data[0]) === '') {
                    continue;
                }

                // ضمان 5 أعمدة
                $data = array_pad($data, 5, '');

                $name        = trim($data[0] ?? '');
                $birth_raw   = trim($data[1] ?? '');
                $address     = trim($data[2] ?? '');
                $job         = trim($data[3] ?? '');
                $national_id = trim($data[4] ?? '');

                // سطر فاضي تقريبًا
                if ($name === '' && $national_id === '' && $address === '' && $job === '' && $birth_raw === '') {
                    continue;
                }

                // تجهيز تاريخ الميلاد
                $birth_date = null;
                if ($birth_raw !== '') {
                    $time = strtotime($birth_raw);
                    if ($time !== false) {
                        $birth_date = date('Y-m-d', $time);
                    }
                }

                $stmt->execute([
                    $name        !== '' ? $name        : null,
                    $birth_date  ?: null,
                    $address     !== '' ? $address     : null,
                    $job         !== '' ? $job         : null,
                    $national_id !== '' ? $national_id : null,
                ]);

                $count++;
                $currentBatch++;

                // كل 10,000 صف نعمل COMMIT ونبدأ Transaction جديدة
                if ($currentBatch >= $batchSize) {
                    $pdo->commit();
                    $pdo->beginTransaction();
                    $currentBatch = 0;
                }
            }

            fclose($handle);

            // COMMIT أخير لو في Transaction مفتوحة
            if ($pdo->inTransaction()) {
                $pdo->commit();
            }

        // ========== معالجة Excel (xlsx / xls) ==========
        } else {

            require_once __DIR__ . '/PhpSpreadsheet/autoload.php';

            $reader = null;
            if ($ext === 'xlsx') {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            } elseif ($ext === 'xls') {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
            } else {
                throw new Exception("امتداد ملف غير مدعوم (مسموح: csv, xlsx, xls)");
            }

            $reader->setReadDataOnly(true);
            $spreadsheet = $reader->load($tmpName);
            $sheet       = $spreadsheet->getActiveSheet();
            $highestRow  = $sheet->getHighestDataRow();

            // الصف الأول هيدر، هنبدأ من الصف 2
            $pdo->beginTransaction();

            for ($row = 2; $row <= $highestRow; $row++) {
                $name        = $sheet->getCellByColumnAndRow(1, $row)->getValue();
                $birth_raw   = $sheet->getCellByColumnAndRow(2, $row)->getValue();
                $address     = $sheet->getCellByColumnAndRow(3, $row)->getValue();
                $job         = $sheet->getCellByColumnAndRow(4, $row)->getValue();
                $national_id = $sheet->getCellByColumnAndRow(5, $row)->getValue();

                if ($name === null && $national_id === null && $address === null && $job === null && $birth_raw === null) {
                    continue; // سطر فاضي
                }

                $name        = trim((string)$name);
                $address     = trim((string)$address);
                $job         = trim((string)$job);
                $national_id = trim((string)$national_id);

                $birth_date = null;
                if (!empty($birth_raw)) {
                    if (is_numeric($birth_raw)) {
                        // تاريخ إكسيل رقمي
                        $unixTime   = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($birth_raw);
                        $birth_date = date('Y-m-d', $unixTime);
                    } else {
                        $time = strtotime($birth_raw);
                        if ($time !== false) {
                            $birth_date = date('Y-m-d', $time);
                        }
                    }
                }

                $stmt->execute([
                    $name        !== '' ? $name        : null,
                    $birth_date  ?: null,
                    $address     !== '' ? $address     : null,
                    $job         !== '' ? $job         : null,
                    $national_id !== '' ? $national_id : null,
                ]);

                $count++;
                $currentBatch++;

                if ($currentBatch >= $batchSize) {
                    $pdo->commit();
                    $pdo->beginTransaction();
                    $currentBatch = 0;
                }
            }

            if ($pdo->inTransaction()) {
                $pdo->commit();
            }
        }

        $msg = "تم استيراد $count صف بنجاح.";

    } catch (Exception $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        $err = "حدث خطأ أثناء الاستيراد: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>نتيجة الاستيراد – X VECTOR</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
      rel="stylesheet"
    >
    <style>
        :root{
          --bg:#020617;--cyan:#22d3ee;--purple:#a855f7;--text:#e5e7eb;
        }
        *{box-sizing:border-box;margin:0;padding:0}
        body{
            background:var(--bg);
            color:var(--text);
            font-family:"Segoe UI",system-ui,sans-serif;
            min-height:100vh;
            display:flex;
            align-items:center;
            justify-content:center;
            overflow:hidden;
        }
        .bg-grid{
            position:fixed;inset:0;
            background-image:
              linear-gradient(rgba(31,41,55,.7) 1px,transparent 1px),
              linear-gradient(90deg,rgba(31,41,55,.7) 1px,transparent 1px);
            background-size:80px 80px;
            opacity:.25;
            animation:bgMove 25s linear infinite;
            pointer-events:none;
        }
        @keyframes bgMove{
          0%{background-position:0 0}
          100%{background-position:80px 80px}
        }
        .network-glow{
            position:fixed;inset:0;
            background:
              radial-gradient(circle at 20% 30%,rgba(34,211,238,.2),transparent 55%),
              radial-gradient(circle at 80% 60%,rgba(168,85,247,.22),transparent 55%);
            mix-blend-mode:screen;
            pointer-events:none;
        }
        .scan-bar{
            position:fixed;left:0;right:0;height:160px;
            background:linear-gradient(to bottom,rgba(34,211,238,0)0%,rgba(34,211,238,.18)40%,rgba(34,211,238,0)100%);
            animation:scanDown 7s linear infinite;
            pointer-events:none;opacity:.7;
        }
        @keyframes scanDown{
          0%{top:-200px}
          100%{top:100%}
        }
        .container-box{
            position:relative;
            z-index:10;
            width:100%;
            max-width:600px;
            padding:1rem;
        }
        .card-xvector{
            background:rgba(15,23,42,0.96);
            border-radius:1.3rem;
            border:1px solid rgba(148,163,184,0.7);
            color:#e5e7eb;
            box-shadow:0 0 32px rgba(0,0,0,0.9);
            padding:1.8rem 1.6rem;
            position:relative;
            overflow:hidden;
        }
        .card-xvector::before{
            content:"";
            position:absolute;
            inset:-1px;
            border-radius:inherit;
            border:1px solid transparent;
            background:conic-gradient(
              from 0deg,
              rgba(34,211,238,.7),
              rgba(168,85,247,0),
              rgba(34,197,94,.75),
              rgba(168,85,247,.3),
              rgba(34,211,238,.8)
            );
            mask:linear-gradient(#000 0 0) padding-box,linear-gradient(#000 0 0);
            mask-composite:exclude;
            opacity:.35;
            animation:borderSpin 10s linear infinite;
            pointer-events:none;
        }
        @keyframes borderSpin{
          0%{transform:rotate(0deg)}
          100%{transform:rotate(360deg)}
        }
        .brand{
            display:flex;
            align-items:center;
            gap:.5rem;
            margin-bottom:1rem;
        }
        .brand-dot{
            width:8px;height:8px;border-radius:50%;
            background:#22c55e;box-shadow:0 0 10px #22c55e;
        }
        .brand-text{
            font-size:.86rem;
            letter-spacing:.18em;
            text-transform:uppercase;
        }
        .badge-node{
            padding:.15rem .6rem;
            border-radius:999px;
            border:1px solid rgba(148,163,184,.7);
            font-size:.7rem;
            color:#9ca3af;
        }
        .title{
            font-size:1.1rem;
            margin-bottom:.5rem;
        }
        .small-muted{color:#9ca3af;font-size:.8rem;}
        a{color:#38bdf8;text-decoration:none}
        a:hover{color:#7dd3fc;text-decoration:underline}
    </style>
</head>
<body>

<div class="bg-grid"></div>
<div class="network-glow"></div>
<div class="scan-bar"></div>

<div class="container-box">
    <div class="card-xvector">
        <div class="brand">
            <span class="brand-dot"></span>
            <div>
                <div class="brand-text">X VECTOR</div>
                <div class="small-muted">IMPORT CHANNEL</div>
            </div>
            <span class="badge-node ms-auto">DB PIPELINE</span>
        </div>

        <?php if ($msg): ?>
            <h5 class="title">عملية الاستيراد مكتملة</h5>
            <div class="alert alert-success py-2 mb-3">
                <?= nl2br(htmlspecialchars($msg)) ?>
            </div>
        <?php endif; ?>

        <?php if ($err): ?>
            <h5 class="title">حدث خطأ أثناء الاستيراد</h5>
            <div class="alert alert-danger py-2 mb-3" style="white-space:pre-line">
                <?= htmlspecialchars($err) ?>
            </div>
        <?php endif; ?>

        <p class="mb-3">
            <a href="index.php">↩ الرجوع للداشبورد</a> |
            <a href="upload_excel.php">رفع ملف آخر</a>
        </p>

        <p class="small-muted mb-0">
            هذه الصفحة تعرض نتيجة عملية ضخ البيانات من ملف CSV / Excel إلى شبكة X VECTOR.
        </p>
    </div>
</div>

</body>
</html>
