<?php
require 'auth.php';

$q = $_GET['q'] ?? '';

$rows = [];
if ($q !== '') {
    $like = "%" . $q . "%";
    $stmt = $pdo->prepare("
        SELECT * FROM users
        WHERE name LIKE ?
           OR national_id LIKE ?
           OR address LIKE ?
           OR job LIKE ?
           OR mobile LIKE ?
        ORDER BY id DESC
        LIMIT 100
    ");
    $stmt->execute([$like, $like, $like, $like, $like]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>اختبار البحث</title>
</head>
<body>

<p><a href="index.php">رجوع للداشبورد</a></p>

<form method="get">
    <label>كلمة البحث:</label>
    <input type="text" name="q" value="<?= htmlspecialchars($q) ?>">
    <button type="submit">بحث</button>
</form>

<?php if ($q !== ''): ?>
    <h3>نتائج البحث</h3>
    <pre><?php print_r($rows); ?></pre>
<?php endif; ?>

</body>
</html>
