<?php
require 'auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>رفع ملف بيانات – X VECTOR</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
      rel="stylesheet"
    >
    <style>
        :root{
          --bg:#020617;--cyan:#22d3ee;--purple:#a855f7;--text:#e5e7eb;
        }
        *{box-sizing:border-box;margin:0;padding:0}
        body{
            background:var(--bg);
            color:var(--text);
            font-family:"Segoe UI",system-ui,sans-serif;
            min-height:100vh;
            display:flex;
            align-items:center;
            justify-content:center;
            overflow:hidden;
        }

        /* SPLASH */
        #splash{
            position:fixed;inset:0;
            background:#020617;
            display:flex;flex-direction:column;
            align-items:center;justify-content:center;
            z-index:10000;
            transition:opacity .7s,visibility .7s;
        }
        #splash.hide{opacity:0;visibility:hidden;pointer-events:none}
        .splash-title{
            font-size:1.7rem;
            letter-spacing:.22em;
            text-transform:uppercase;
            color:var(--cyan);
            text-shadow:0 0 20px var(--cyan);
        }
        .splash-sub{
            font-size:.8rem;
            color:#9ca3af;
            letter-spacing:.15em;
            margin-top:.3rem;
        }
        .splash-bar{
            width:160px;height:3px;border-radius:999px;
            overflow:hidden;margin-top:1.2rem;
            background:rgba(15,23,42,.9);
        }
        .splash-bar-inner{
            width:40%;height:100%;
            background:linear-gradient(90deg,#0ea5e9,#22c55e);
            animation:splashMove 1.4s linear infinite;
        }
        @keyframes splashMove{
            0%{transform:translateX(-100%)}
            100%{transform:translateX(250%)}
        }

        /* BACKGROUND FX */
        .bg-grid{
            position:fixed;inset:0;
            background-image:
              linear-gradient(rgba(31,41,55,.7) 1px,transparent 1px),
              linear-gradient(90deg,rgba(31,41,55,.7) 1px,transparent 1px);
            background-size:80px 80px;
            opacity:.25;
            animation:bgMove 25s linear infinite;
            pointer-events:none;
        }
        @keyframes bgMove{
          0%{background-position:0 0}
          100%{background-position:80px 80px}
        }
        .network-glow{
            position:fixed;inset:0;
            background:
              radial-gradient(circle at 20% 30%,rgba(34,211,238,.2),transparent 55%),
              radial-gradient(circle at 80% 60%,rgba(168,85,247,.22),transparent 55%);
            mix-blend-mode:screen;
            pointer-events:none;
        }
        .scan-bar{
            position:fixed;left:0;right:0;height:160px;
            background:linear-gradient(to bottom,rgba(34,211,238,0)0%,rgba(34,211,238,.18)40%,rgba(34,211,238,0)100%);
            animation:scanDown 7s linear infinite;
            pointer-events:none;opacity:.7;
        }
        @keyframes scanDown{
          0%{top:-200px}
          100%{top:100%}
        }

        .container-box{
            position:relative;
            z-index:10;
            width:100%;
            max-width:620px;
            padding:1rem;
        }
        .card-xvector{
            background:rgba(15,23,42,0.96);
            border-radius:1.3rem;
            border:1px solid rgba(148,163,184,0.7);
            color:#e5e7eb;
            box-shadow:0 0 32px rgba(0,0,0,0.9);
            padding:1.8rem 1.6rem;
            position:relative;
            overflow:hidden;
        }
        .card-xvector::before{
            content:"";
            position:absolute;
            inset:-1px;
            border-radius:inherit;
            border:1px solid transparent;
            background:conic-gradient(
              from 0deg,
              rgba(34,211,238,.7),
              rgba(168,85,247,0),
              rgba(34,197,94,.75),
              rgba(168,85,247,.3),
              rgba(34,211,238,.8)
            );
            mask:linear-gradient(#000 0 0) padding-box,linear-gradient(#000 0 0);
            mask-composite:exclude;
            opacity:.35;
            animation:borderSpin 10s linear infinite;
            pointer-events:none;
        }
        @keyframes borderSpin{
          0%{transform:rotate(0deg)}
          100%{transform:rotate(360deg)}
        }

        .brand{
            display:flex;
            align-items:center;
            gap:.5rem;
            margin-bottom:1rem;
        }
        .brand-dot{
            width:8px;height:8px;border-radius:50%;
            background:#22c55e;box-shadow:0 0 10px #22c55e;
        }
        .brand-text{
            font-size:.86rem;
            letter-spacing:.18em;
            text-transform:uppercase;
        }
        .badge-node{
            padding:.15rem .6rem;
            border-radius:999px;
            border:1px solid rgba(148,163,184,.7);
            font-size:.7rem;
            color:#9ca3af;
        }
        .title{
            font-size:1.05rem;
            margin-bottom:.7rem;
        }
        .form-control{
            background:rgba(15,23,42,0.95);
            border-radius:.75rem;
            border:1px solid rgba(148,163,184,0.7);
            color:#e5e7eb;
        }
        .form-control:focus{
            border-color:var(--cyan);
            box-shadow:0 0 8px var(--cyan);
        }
        .btn-cyber{
            border-radius:999px;
            border:1px solid var(--cyan);
            background:linear-gradient(135deg,#0ea5e9,#22c55e);
            color:#020617;
            font-weight:600;
            box-shadow:0 0 18px var(--cyan);
        }
        a{color:#38bdf8;text-decoration:none}
        a:hover{color:#7dd3fc;text-decoration:underline}
        .small-muted{color:#9ca3af;font-size:.8rem;}
    </style>
</head>
<body>

<div id="splash">
  <div class="splash-title">X VECTOR</div>
  <div class="splash-sub">UPLINK CHANNEL · IMPORT</div>
  <div class="splash-bar"><div class="splash-bar-inner"></div></div>
</div>

<div class="bg-grid"></div>
<div class="network-glow"></div>
<div class="scan-bar"></div>

<div class="container-box">
    <div class="card-xvector">
        <div class="brand">
            <span class="brand-dot"></span>
            <div>
                <div class="brand-text">X VECTOR</div>
                <div class="small-muted">IMPORT CHANNEL</div>
            </div>
            <span class="badge-node ms-auto">UPLOAD PIPE</span>
        </div>

        <h4 class="title mb-3">رفع ملف بيانات إلى الشبكة</h4>

        <form method="post"
              action="process_csv.php"
              enctype="multipart/form-data"
              class="mb-3">

            <div class="mb-3">
                <label class="form-label">اختر ملف CSV أو Excel (xls/xlsx)</label>
                <input type="file"
                       name="file"
                       class="form-control"
                       required
                       accept=".csv,.xls,.xlsx">
            </div>

            <button type="submit" name="upload" class="btn-cyber px-4">
                رفع ومعالجة
            </button>
        </form>

        <p class="small-muted">
            ✅ الأعمدة المطلوبة في الهيدر بالترتيب:<br>
            <code>name;birth_date;address;job;national_id</code><br><br>
            لو الملف CSV السكربت هيتعرّف تلقائيًا على الفاصل سواء <code>;</code> أو <code>,</code>.<br>
            لو الملف Excel (xlsx/xls) أول صف لازم يكون الهيدر، والباقي بيانات.
        </p>

        <a href="index.php" class="small-muted">↩ العودة إلى لوحة التحكم</a>
    </div>
</div>

<script>
(function(){
  function hideSplash(){
    const s=document.getElementById('splash');
    if(s) s.classList.add('hide');
  }
  window.addEventListener('load',function(){
    setTimeout(hideSplash,600); // نفس فكرة الـ Dashboard
  });
  setTimeout(hideSplash,2500); // أمان لو الـ load اتأخر
})();
</script>

</body>
</html>
